function NavMapNode(nodeRef, navRef)
{
	this.nodeRef = nodeRef;
	this.navRef = navRef;

	this.id = "";
	this.tag = "";
	this.title = "";
	
	this.blockingNodeId = "";
	this.blocked = false;
	this.blockedForwardOnly = false;
	this.disabled = false;
	this.exhausted = false;
	this.visible = true;

	this.containsCurrentNode = false;
	this.isCurrentNode = false;
	
	// position is an array containing sibling position
	// for the node and all of its ancestors.  Element [0]
	// represents the root of the tree, and each successive
	// element represents the next level down.
	this.position = new Array();
	// order represents the relative position of the node
	// in relation to its immediate siblings.  1 means it's
	// the first sibling, 2 the second, and so on.
	this.order = 0;
	// Depth holds the number of levels below the root of the
	// tree that the node resides.  0 means that the node is
	// the root, 1 means one level below the root, and so on.
	this.depth = 0;
	
	this.attempted = false;
	this.completed = false;
	this.satisfied = false;
	
	this.parent = null;
	this.children = new Array();
	
	if (nodeRef != null && typeof(nodeRef) == "object" && nodeRef.constructor == NavNode)
	{
		this.id = nodeRef.id;
		this.tag = nodeRef.tag;
		this.title = nodeRef.title;
		this.visible = nodeRef.visible;
		this.attempted = nodeRef.attempted;
		this.completed = nodeRef.completed;
		this.satisfied = nodeRef.satisfied;
		this.position = nodeRef.position.concat();
		this.order = this.position[this.position.length-1];
		this.depth = this.position.length-1;
		
		var retVal = navRef.evalGotoNode(nodeRef.id);
		if (retVal != NAV_DENY_NONE)
		{
			switch (retVal)
			{
				case NAV_DENY_BLOCKED:this.blocked=true;this.blockingNodeId=navRef.blockedNode.id;break;
				case NAV_DENY_ANCESTOR_DISABLED:this.disabled=true;break;
				case NAV_DENY_PARENT_DISABLED:this.disabled=true;break;
				case NAV_DENY_DISABLED:this.disabled=true;break;
				case NAV_DENY_FORWARD_ONLY:this.blockedForwardOnly=true;this.blockingNodeId=navRef.blockedNode.id;break;
				case NAV_DENY_EXHAUSTED:this.exhausted=true;break;
			}
		}
		
		// Determine if navEngine.currentNode is, or is located beneath, nodeRef.
		var currentNode = navEngine.currentNode;
		if (currentNode != null)
		{
			if (currentNode == nodeRef)
			{
				this.containsCurrentNode = true;
				this.isCurrentNode = true;
			}
			else
			{
				var tempNode = currentNode.parentStack[0];
				while (tempNode != null)
				{
					if (nodeRef == tempNode)
					{
						this.containsCurrentNode = true;
						break;
					}
					tempNode = tempNode.parentStack[0];
				}
			}
		}
	}
}